"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** Returns the first node or element with `textContent` matching `expectedText`. */
const findNodeWithText = (expectedText, parent, options = {}) => {
    const { tag } = options;
    if (parent.textContent === expectedText) {
        const matchesTag = (() => {
            // No tag check necessary?
            if (!tag)
                return true;
            return parent instanceof Element && tag.toUpperCase() === parent.tagName;
        })();
        if (matchesTag) {
            return parent;
        }
    }
    for (const child of parent.childNodes) {
        const results = findNodeWithText(expectedText, child, options);
        if (results) {
            return results;
        }
    }
    return null;
};
exports.default = findNodeWithText;
