"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sendKeyPressRelease_1 = __importDefault(require("./sendKeyPressRelease"));
/** Sets the content of the given `input` or textarea to be `text`. */
const fillInput = (input, text, { clear = false } = {}) => {
    const dispatchUpdate = () => {
        input.dispatchEvent(new InputEvent('input'));
    };
    if (clear) {
        input.value = '';
        dispatchUpdate();
    }
    for (const character of text.split('')) {
        input.value += character;
        (0, sendKeyPressRelease_1.default)(input, character);
        dispatchUpdate();
    }
};
exports.default = fillInput;
