"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Display_1 = require("../rendering/Display");
const Editor_1 = __importDefault(require("../Editor"));
const getLocalizationTable_1 = __importDefault(require("../localizations/getLocalizationTable"));
/** Creates an editor. Should only be used in test files. */
exports.default = (settings) => {
    if (jest === undefined) {
        throw new Error('Files in the testing/ folder should only be used in tests!');
    }
    return new Editor_1.default(document.body, {
        renderingMode: Display_1.RenderingMode.DummyRenderer,
        localization: (0, getLocalizationTable_1.default)(['en']),
        ...settings,
    });
};
