export interface KeyCombination {
    /** A key (e.g. `a`, `b`, `control`). */
    readonly key: string;
    /**
     * The layout-independent name of the key being pressed. For example,
     * KeyA for the `a` key.
     */
    readonly code?: string;
    /**
     * Whether the shift key must be pressed to trigger the shortcut.
     */
    readonly shiftKey: boolean | undefined;
    /** Whether the control key must be pressed to trigger the shortcut */
    readonly ctrlKey: boolean;
    /** Whether the alt key must be pressed to trigger the shortcut */
    readonly altKey: boolean;
    /** Whether the meta key must be pressed to trigger the shortcut */
    readonly metaKey: boolean;
    /** True if this shortcut/key combination applies for either control or meta. */
    readonly controlOrMeta: boolean;
}
/** Represents a key combination that can trigger a keyboard shortcut. */
export default class KeyBinding implements KeyCombination {
    /** @inheritdoc */
    readonly key: string;
    /**
     * If undefined, the state of the shift key is ignored.
     */
    readonly shiftKey: boolean | undefined;
    /** @inheritdoc */
    readonly ctrlKey: boolean;
    /** @inheritdoc */
    readonly altKey: boolean;
    /** @inheritdoc */
    readonly metaKey: boolean;
    /** @inheritdoc */
    readonly controlOrMeta: boolean;
    constructor(trigger: KeyCombination);
    /** Returns true if and only if `keyEvent` should trigger this shortcut. */
    matchesEvent(keyEvent: Partial<KeyCombination>): boolean;
    /**
     * Returns a string representation of this shortcut in the same format accepted by
     * {@link fromString}.
     */
    toString(): string;
    /**
     * Accepts a string in the form `modifier1+modifier2+...+key` (e.g. `Ctrl+Shift+a`)
     * and returns the corresponding `KeyboardShortcut`.
     */
    static fromString(shortcutStr: string): KeyBinding;
}
