import { Vec3, Rect2, Mat33 } from '@js-draw/math';
import Viewport from '../../Viewport';
import { TextRendererLocalization } from '../localization';
import RenderingStyle from '../RenderingStyle';
import TextRenderingStyle from '../TextRenderingStyle';
import AbstractRenderer, { RenderableImage } from './AbstractRenderer';
export default class TextOnlyRenderer extends AbstractRenderer {
    private localizationTable;
    private descriptionBuilder;
    private pathCount;
    private textNodeCount;
    private imageNodeCount;
    constructor(viewport: Viewport, localizationTable: TextRendererLocalization);
    displaySize(): Vec3;
    clear(): void;
    getDescription(): string;
    protected beginPath(_startPoint: Vec3): void;
    protected endPath(_style: RenderingStyle): void;
    protected lineTo(_point: Vec3): void;
    protected moveTo(_point: Vec3): void;
    protected traceCubicBezierCurve(_p1: Vec3, _p2: Vec3, _p3: Vec3): void;
    protected traceQuadraticBezierCurve(_controlPoint: Vec3, _endPoint: Vec3): void;
    drawText(text: string, _transform: Mat33, _style: TextRenderingStyle): void;
    drawImage(image: RenderableImage): void;
    isTooSmallToRender(rect: Rect2): boolean;
    drawPoints(..._points: Vec3[]): void;
}
