import { Mat33, Rect2, Point2, Vec2, Vec3 } from '@js-draw/math';
import Viewport from '../../Viewport';
import RenderingStyle from '../RenderingStyle';
import TextRenderingStyle from '../TextRenderingStyle';
import AbstractRenderer, { RenderableImage } from './AbstractRenderer';
export default class DummyRenderer extends AbstractRenderer {
    clearedCount: number;
    renderedPathCount: number;
    lastFillStyle: RenderingStyle | null;
    lastPoint: Point2 | null;
    objectNestingLevel: number;
    lastText: string | null;
    lastImage: RenderableImage | null;
    pointBuffer: Point2[];
    constructor(viewport: Viewport);
    displaySize(): Vec2;
    clear(): void;
    protected beginPath(startPoint: Vec3): void;
    protected endPath(style: RenderingStyle): void;
    protected lineTo(point: Vec3): void;
    protected moveTo(point: Point2): void;
    protected traceCubicBezierCurve(p1: Vec3, p2: Vec3, p3: Vec3): void;
    protected traceQuadraticBezierCurve(controlPoint: Vec3, endPoint: Vec3): void;
    drawPoints(..._points: Vec3[]): void;
    drawText(text: string, _transform: Mat33, _style: TextRenderingStyle): void;
    drawImage(image: RenderableImage): void;
    startObject(boundingBox: Rect2, _clip: boolean): void;
    endObject(): void;
    isTooSmallToRender(_rect: Rect2): boolean;
    canRenderFromWithoutDataLoss(other: AbstractRenderer): other is DummyRenderer;
    renderFromOtherOfSameType(transform: Mat33, other: AbstractRenderer): void;
    toString(): string;
}
