import { Mat33, Rect2, Point2, Vec2, Vec3 } from '@js-draw/math';
import Viewport from '../../Viewport';
import RenderingStyle from '../RenderingStyle';
import TextRenderingStyle from '../TextRenderingStyle';
import AbstractRenderer, { RenderableImage } from './AbstractRenderer';
import RenderablePathSpec from '../RenderablePathSpec';
/**
 * Renders onto a `CanvasRenderingContext2D`.
 *
 * **Example**:
 * [[include:doc-pages/inline-examples/canvas-renderer.md]]
 */
export default class CanvasRenderer extends AbstractRenderer {
    private ctx;
    private ignoreObjectsAboveLevel;
    private ignoringObject;
    private currentObjectBBox;
    private minSquareCurveApproxDist;
    private minRenderSizeAnyDimen;
    private minRenderSizeBothDimens;
    /**
     * Creates a new `CanvasRenderer` that renders to the given rendering context.
     * The `viewport` is used to determine the translation/rotation/scaling of the content
     * to draw.
     */
    constructor(ctx: CanvasRenderingContext2D, viewport: Viewport);
    private transformBy;
    canRenderFromWithoutDataLoss(other: AbstractRenderer): other is CanvasRenderer;
    renderFromOtherOfSameType(transformBy: Mat33, other: AbstractRenderer): void;
    setDraftMode(draftMode: boolean): void;
    displaySize(): Vec2;
    clear(): void;
    protected beginPath(startPoint: Point2): void;
    protected endPath(style: RenderingStyle): void;
    protected lineTo(point: Point2): void;
    protected moveTo(point: Point2): void;
    protected traceCubicBezierCurve(p1: Point2, p2: Point2, p3: Point2): void;
    protected traceQuadraticBezierCurve(controlPoint: Vec3, endPoint: Vec3): void;
    drawPath(path: RenderablePathSpec): void;
    drawText(text: string, transform: Mat33, style: TextRenderingStyle): void;
    drawImage(image: RenderableImage): void;
    private clipLevels;
    startObject(boundingBox: Rect2, clip?: boolean): void;
    endObject(): void;
    /**
     * Returns a reference to the underlying `CanvasRenderingContext2D`.
     * This can be used to render custom content not supported by {@link AbstractRenderer}.
     * However, such content won't support {@link SVGRenderer} or {@link TextOnlyRenderer}
     * by default.
     *
     * Use with caution.
     */
    drawWithRawRenderingContext(callback: (ctx: CanvasRenderingContext2D) => void): void;
    drawPoints(...points: Point2[]): void;
    isTooSmallToRender(rect: Rect2): boolean;
    static fromViewport(exportViewport: Viewport, options?: {
        canvasSize?: Vec2;
        maxCanvasDimen?: number;
    }): {
        renderer: CanvasRenderer;
        element: HTMLCanvasElement;
    };
}
