"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const CanvasRenderer_1 = __importDefault(require("./CanvasRenderer"));
class CanvasInkPresenter {
    constructor(canvas, viewport) {
        this.viewport = viewport;
        this.enabled = new Map();
        this.presenter = null;
        this.style = { color: 'black', diameter: 2 };
        if ('ink' in navigator && navigator.ink) {
            const ink = navigator.ink;
            ink.requestPresenter({ presentationArea: canvas }).then((presenter) => {
                this.presenter = presenter;
            });
        }
    }
    setEnabled(pointerId, enabled) {
        this.enabled.set(pointerId, enabled);
    }
    updateStyle(style) {
        const colorString = style.color.toString();
        // style.diameter must be a postive integer.
        this.style = {
            color: colorString,
            diameter: Math.ceil(style.width / this.viewport.getSizeOfPixelOnCanvas()),
        };
    }
    onEvent(event) {
        if (this.presenter && this.enabled.get(event.pointerId) && event.isTrusted) {
            this.presenter.updateInkTrailStartPoint(event, this.style);
        }
    }
}
/** A canvas that uses the web ink API for accelerated inking. */
class AcceleratedInkingCanvasRenderer extends CanvasRenderer_1.default {
    constructor(ctx, viewport) {
        super(ctx, viewport);
        this.inkPresenter = new CanvasInkPresenter(ctx.canvas, viewport);
    }
    getDraftInkPresenter() {
        return this.inkPresenter;
    }
    onEvent(event) {
        this.inkPresenter.onEvent(event);
    }
}
exports.default = AcceleratedInkingCanvasRenderer;
