import type { Vec2 } from '@js-draw/math';
import type AbstractRenderer from '../renderers/AbstractRenderer';
import type { CacheRecordManager } from './CacheRecordManager';
export type CacheAddress = number;
export type BeforeDeallocCallback = () => void;
export interface CacheProps {
    createRenderer(): AbstractRenderer;
    isOfCorrectType(renderer: AbstractRenderer): boolean;
    blockResolution: Vec2;
    cacheSize: number;
    maxScale: number;
    minProportionalRenderTimePerCache: number;
    minProportionalRenderTimeToUseCache: number;
}
export interface CacheState {
    currentRenderingCycle: number;
    props: CacheProps;
    recordManager: CacheRecordManager;
    debugMode: boolean;
}
