"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCache = void 0;
const math_1 = require("@js-draw/math");
const DummyRenderer_1 = __importDefault(require("../renderers/DummyRenderer"));
const createEditor_1 = __importDefault(require("../../testing/createEditor"));
const RenderingCache_1 = __importDefault(require("./RenderingCache"));
// Override any default test options with [cacheOptions]
const createCache = (onRenderAlloc, cacheOptions) => {
    const editor = (0, createEditor_1.default)();
    const cache = new RenderingCache_1.default({
        createRenderer() {
            const renderer = new DummyRenderer_1.default(editor.viewport);
            onRenderAlloc?.(renderer);
            return renderer;
        },
        isOfCorrectType(renderer) {
            return renderer instanceof DummyRenderer_1.default;
        },
        blockResolution: math_1.Vec2.of(500, 500),
        cacheSize: 500 * 10 * 4,
        maxScale: 2,
        minProportionalRenderTimePerCache: 0,
        minProportionalRenderTimeToUseCache: 0,
        ...cacheOptions,
    });
    return {
        cache,
        editor,
    };
};
exports.createCache = createCache;
