"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.textStyleToJSON = exports.textStyleFromJSON = exports.cloneTextStyle = void 0;
const RenderingStyle_1 = require("./RenderingStyle");
const cloneTextStyle = (style) => {
    return {
        ...style,
        renderingStyle: (0, RenderingStyle_1.cloneStyle)(style.renderingStyle),
    };
};
exports.cloneTextStyle = cloneTextStyle;
/** `json` can either be a `string` or an `object`. */
const textStyleFromJSON = (json) => {
    if (typeof json === 'string') {
        json = JSON.parse(json);
    }
    if (typeof json.fontFamily !== 'string') {
        throw new Error('Serialized textStyle missing string fontFamily attribute!');
    }
    const style = {
        renderingStyle: (0, RenderingStyle_1.styleFromJSON)(json.renderingStyle),
        size: json.size,
        fontWeight: json.fontWeight,
        fontVariant: json.fontVariant,
        fontFamily: json.fontFamily,
    };
    return style;
};
exports.textStyleFromJSON = textStyleFromJSON;
const textStyleToJSON = (style) => {
    return {
        ...style,
        renderingStyle: (0, RenderingStyle_1.styleToJSON)(style.renderingStyle),
    };
};
exports.textStyleToJSON = textStyleToJSON;
