import RenderingStyle from './RenderingStyle';
export interface TextRenderingStyle {
    readonly size: number;
    /** Name of the font. */
    readonly fontFamily: string;
    /** For example, `bold`. Like CSS `font-weight`. */
    readonly fontWeight?: string;
    /** For example, `italic`. Like CSS `font-style`. */
    readonly fontStyle?: string;
    readonly fontVariant?: string;
    /** Fill and stroke of the text. */
    readonly renderingStyle: RenderingStyle;
}
export default TextRenderingStyle;
export declare const cloneTextStyle: (style: TextRenderingStyle) => {
    renderingStyle: {
        fill: import("@js-draw/math").Color4;
        stroke: {
            color: import("@js-draw/math").Color4;
            width: number;
        } | undefined;
    };
    size: number;
    fontFamily: string;
    fontWeight?: string;
    fontStyle?: string;
    fontVariant?: string;
};
/** `json` can either be a `string` or an `object`. */
export declare const textStyleFromJSON: (json: any) => TextRenderingStyle;
export declare const textStyleToJSON: (style: TextRenderingStyle) => {
    renderingStyle: {
        fill: string;
        stroke: {
            color: string;
            width: number;
        } | undefined;
    };
    size: number;
    fontFamily: string;
    fontWeight?: string;
    fontStyle?: string;
    fontVariant?: string;
};
