"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.styleFromJSON = exports.styleToJSON = exports.stylesEqual = exports.cloneStyle = void 0;
const math_1 = require("@js-draw/math");
const cloneStyle = (style) => {
    return {
        fill: style.fill,
        stroke: style.stroke
            ? {
                ...style.stroke,
            }
            : undefined,
    };
};
exports.cloneStyle = cloneStyle;
const stylesEqual = (a, b) => {
    const result = a === b ||
        (a.fill.eq(b.fill) &&
            (a.stroke == undefined) === (b.stroke == undefined) &&
            (a.stroke?.color?.eq(b.stroke?.color) ?? true) &&
            a.stroke?.width === b.stroke?.width);
    // Map undefined/null -> false
    return result ?? false;
};
exports.stylesEqual = stylesEqual;
// Returns an object that can be converted to a JSON string with
// JSON.stringify.
const styleToJSON = (style) => {
    const stroke = !style.stroke
        ? undefined
        : {
            color: style.stroke.color.toHexString(),
            width: style.stroke.width,
        };
    return {
        fill: style.fill.toHexString(),
        stroke,
    };
};
exports.styleToJSON = styleToJSON;
const styleFromJSON = (json) => {
    const stroke = json.stroke
        ? {
            color: math_1.Color4.fromHex(json.stroke.color),
            width: json.stroke.width,
        }
        : undefined;
    return {
        fill: math_1.Color4.fromHex(json.fill),
        stroke,
    };
};
exports.styleFromJSON = styleFromJSON;
