import { Path, PathCommand, Point2, Rect2 } from '@js-draw/math';
import RenderingStyle from './RenderingStyle';
interface RenderablePathSpec {
    startPoint: Point2;
    commands: PathCommand[];
    style: RenderingStyle;
    path?: Path;
}
export interface RenderablePathSpecWithPath extends RenderablePathSpec {
    path: Path;
}
/** Converts a renderable path (a path with a `startPoint`, `commands`, and `style`). */
export declare const pathFromRenderable: (renderable: RenderablePathSpec) => Path;
/**
 * Converts `path` into a format that can be rendered (by passing to a {@link Stroke} constructor
 * or directly to an {@link AbstractRenderer.drawPath}).
 */
export declare const pathToRenderable: (path: Path, style: RenderingStyle) => RenderablePathSpecWithPath;
interface RectangleSimplificationResult {
    rectangle: Rect2;
    path: RenderablePathSpecWithPath;
    fullScreen: boolean;
}
/**
 * Tries to simplify the given path to a fullscreen rectangle.
 * Returns `null` on failure.
 *
 * @internal
 */
export declare const simplifyPathToFullScreenOrEmpty: (renderablePath: RenderablePathSpec, visibleRect: Rect2, options?: {
    fastCheck: boolean;
    expensiveCheck: boolean;
}) => RectangleSimplificationResult | null;
/**
 * @returns a Path that, when rendered, looks roughly equivalent to the given path.
 */
export declare const visualEquivalent: (renderablePath: RenderablePathSpec, visibleRect: Rect2) => RenderablePathSpecWithPath;
export default RenderablePathSpec;
