"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const localization_1 = require("../localization");
// Chinese localization
const localization = {
    ...localization_1.defaultEditorLocalization,
    help: '帮助',
    helpHidden: '帮助已隐藏',
    next: '下一页',
    previous: '上一页',
    close: '关闭',
    helpScreenNavigationHelp: '点击控件查看更多信息。',
    helpControlsAccessibilityLabel: '控件：激活控件以显示帮助。',
    pen: '画笔',
    eraser: '橡皮擦',
    select: '选择',
    handTool: '平移',
    zoom: '缩放',
    image: '图片',
    reformatSelection: '格式化选区',
    inputAltText: '替代文本',
    decreaseImageSize: '减小尺寸',
    resetImage: '重置',
    chooseFile: '选择文件',
    dragAndDropHereOrBrowse: '将文件拖拽到此处或{{浏览}}',
    submit: '提交',
    addAll: '全部添加',
    cancel: '取消',
    resetView: '重置视图',
    thicknessLabel: '粗细',
    colorLabel: '颜色',
    fontLabel: '字体',
    textSize: '字号',
    resizeImageToSelection: '按选区调整图片大小',
    deleteSelection: '删除选区',
    duplicateSelection: '复制选区',
    exit: '退出',
    save: '保存',
    undo: '撤销',
    redo: '重做',
    fullStrokeEraser: '全笔划橡皮擦',
    selectPenType: '工具类型',
    selectShape: '形状',
    pickColorFromScreen: '从屏幕取色',
    clickToPickColorAnnouncement: '点击屏幕以选取颜色',
    colorSelectionCanceledAnnouncement: '颜色选择已取消',
    selectionTool__lassoSelect: '自由选区',
    selectionTool__lassoSelect__help: '启用后，拖拽将创建自由形式（套索）选区。',
    selectionToolKeyboardShortcuts: '选择工具：使用方向键移动所选项目，使用小写/大写 “i” 和 “o” 调整大小。',
    documentProperties: '页面',
    backgroundColor: '背景色',
    imageWidthOption: '宽度',
    imageHeightOption: '高度',
    useGridOption: '网格',
    enableAutoresizeOption: '自动调整大小',
    toggleOverflow: '更多',
    about: '关于',
    inputStabilization: '稳定',
    strokeAutocorrect: '自动更正',
    pressureSensitivity: '压力',
    touchPanning: '触屏平移',
    roundedTipPen: '自由画笔',
    roundedTipPen2: '折线',
    flatTipPen: '平头笔',
    arrowPen: '箭头',
    linePen: '直线',
    outlinedRectanglePen: '空心矩形',
    filledRectanglePen: '实心矩形',
    outlinedCirclePen: '空心圆',
    lockRotation: '锁定旋转',
    paste: '粘v贴',
    errorImageHasZeroSize: '错误：图片尺寸为零',
    describeTheImage: '图像描述',
    fileInput__loading: '加载中...',
    fileInput__andNMoreFiles: (n) => `(还有 ${n} 个)`,
    closeSidebar: (toolName) => `关闭 ${toolName} 的侧边栏`,
    dropdownShown: (toolName) => `已显示 ${toolName} 下拉菜单`,
    dropdownHidden: (toolName) => `已隐藏 ${toolName} 下拉菜单`,
    zoomLevel: (zoomPercent) => `缩放：${zoomPercent}%`,
    colorChangedAnnouncement: (color) => `颜色已更改为 ${color}`,
    imageSize: (size, units) => `图片尺寸：${size} ${units}`,
    imageLoadError: (message) => `图片加载错误：${message}`,
    penTool: (penId) => `画笔 ${penId}`,
    selectionTool: '选择工具',
    selectAllTool: '全选',
    eraserTool: '橡皮擦工具',
    touchPanTool: '触屏平移工具',
    twoFingerPanZoomTool: '双指平移与缩放',
    undoRedoTool: '撤销/重做工具',
    rightClickDragPanTool: '右键拖拽',
    pipetteTool: '取色器',
    keyboardPanZoom: '键盘平移与缩放快捷键',
    selectionMenu__show: '显示选择菜单',
    selectionMenu__copyToClipboard: '复制到剪贴板',
    selectionMenu__duplicate: '复制',
    selectionMenu__delete: '删除',
    selectionMenu__paste: '粘贴',
    copyPasteError__heading: '复制/粘贴',
    copyPasteError__description: '出错了——此工具可能无法访问剪贴板。',
    copyPasteError__errorDetails: '显示错误',
    copyPasteError__pasteRetry: '请重试：在下方输入框中粘贴：',
    copyPasteError__copyRetry: '请重试：在下方输入框中复制文本：',
    copyPasteError__copyMe: '点我复制！',
    autocorrectedTo: (strokeDescription) => `已自动更正为 ${strokeDescription}`,
    autocorrectionCanceled: '自动更正已取消',
    textTool: '文本工具',
    enterTextToInsert: '输入要插入的文本',
    changeTool: '切换工具',
    pasteHandler: '复制粘贴处理器',
    soundExplorer: '声音探索',
    disableAccessibilityExploreTool: '关闭声音探索',
    enableAccessibilityExploreTool: '开启声音探索',
    soundExplorerUsageAnnouncement: '已启用声音图像探索：点击或拖拽屏幕，即可通过声音感受图像不同区域。',
    findLabel: '查找',
    toNextMatch: '下一个',
    closeDialog: '关闭',
    findDialogShown: '已显示查找对话框',
    findDialogHidden: '已隐藏查找对话框',
    focusedFoundText: (matchIdx, totalMatches) => `第 ${matchIdx} 条结果，共 ${totalMatches} 条`,
    anyDevicePanning: '任意设备平移',
    copied: (count) => `已复制 ${count} 个项目`,
    pasted: (count) => `已粘贴 ${count} 个项目`,
    toolEnabledAnnouncement: (toolName) => `${toolName} 已启用`,
    toolDisabledAnnouncement: (toolName) => `${toolName} 已禁用`,
    updatedViewport: '已更新视口',
    transformedElements: (elemCount, action) => `${elemCount} 个元素已变换 (${action})`,
    resizeOutputCommand: (newSize) => `图片尺寸已更改为 ${newSize.w}×${newSize.h}`,
    enabledAutoresizeOutputCommand: '已启用输出自动调整大小',
    disabledAutoresizeOutputCommand: '已禁用输出自动调整大小',
    addComponentAction: (componentDescription) => `已添加 ${componentDescription}`,
    eraseAction: (componentDescription, countErased) => `已删除 ${countErased} 个 ${componentDescription}`,
    duplicateAction: (componentDescription, countErased) => `已复制 ${countErased} 个 ${componentDescription}`,
    unionOf: (actionDescription, actionCount) => `合并：${actionCount} 个 ${actionDescription}`,
    inverseOf: (actionDescription) => `${actionDescription} 已反向`,
    elements: '元素',
    erasedNoElements: '未v删除任何内容',
    duplicatedNoElements: '未复制任何内容',
    rotatedBy: (degrees) => `已旋转 ${Math.abs(degrees)} 度 ${degrees < 0 ? '顺时针' : '逆时针'}`,
    movedLeft: '已向左移动',
    movedUp: '已向上移动',
    movedDown: '已向下移动',
    movedRight: '已向右移动',
    zoomedOut: '已缩小',
    zoomedIn: '已放大',
    andNMoreCommands: (count) => `还有 ${count} 条命令。`,
    selectedElements: (count) => `已选 ${count} 个元素`,
    unlabeledImageNode: '未命名图片',
    stroke: '笔画',
    svgObject: 'SVG 对象',
    emptyBackground: '空白背景',
    gridBackground: '网格背景',
    filledBackgroundWithColor: (color) => `已填充背景（${color}）`,
    text: (text) => `文本对象：${text}`,
    imageNode: (label) => `图片：${label}`,
    restyledElement: (elementDescription) => `已重新样式化 ${elementDescription}`,
    pathNodeCount: (count) => `可见路径对象：${count} 个`,
    textNodeCount: (count) => `可见文本节点：${count} 个`,
    imageNodeCount: (nodeCount) => `可见图片节点：${nodeCount} 个`,
    textNode: (content) => `文本：${content}`,
    rerenderAsText: '以文本形式重绘',
    accessibilityInputInstructions: '按“t”将视口内容朗读为文本。使用方向键移动视口，点击并拖拽绘制笔画。按“w”放大，按“s”缩小。',
    loading: (percentage) => `加载中 ${percentage}%...`,
    imageEditor: '图片编辑器',
    doneLoading: '加载完成',
    undoAnnouncement: (commandDescription) => `已撤销 ${commandDescription}`,
    redoAnnouncement: (commandDescription) => `已重做 ${commandDescription}`,
    softwareLibraries: '软件库',
    developerInformation: '开发者信息',
};
exports.default = localization;
