"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const localization_1 = require("../localization");
// Slovak localization
const localization = {
    ...localization_1.defaultEditorLocalization,
    help: 'Pomoc',
    helpHidden: 'Skrytá pomoc',
    next: 'Ďalšie',
    previous: 'Prechádzajúce',
    close: 'Zavrieť',
    helpScreenNavigationHelp: 'Kliknutím na ovládací prvok získate viac informácií.',
    helpControlsAccessibilityLabel: 'Ovládacie prvky: Aktivujte ovládací prvok, ktorý zobrazí pomoc.',
    pen: 'Pero',
    eraser: 'Guma',
    select: 'Vybrať',
    handTool: 'Posun',
    zoom: 'Priblížiť',
    image: 'Obrázok',
    reformatSelection: 'Výber formátu',
    inputAltText: 'Alternatívny text',
    decreaseImageSize: 'Zmenšiť veľkosť',
    resetImage: 'Obnoviť',
    chooseFile: 'Vybrať súbor',
    dragAndDropHereOrBrowse: 'Presuňte sem alebo {{prehľadávať}}',
    submit: 'Odoslať',
    addAll: 'Pridať všetko',
    cancel: 'Zrušiť',
    resetView: 'Obnoviť zobrazenie',
    thicknessLabel: 'Hrúbka',
    colorLabel: 'Farba',
    fontLabel: 'Písmo',
    textSize: 'Veľkosť',
    resizeImageToSelection: 'Zmena veľkosti obrázka podľa výberu',
    deleteSelection: 'Vymazať výber',
    duplicateSelection: 'Duplikovať výber',
    exit: 'Ukončiť',
    save: 'Uložiť',
    undo: 'Späť',
    redo: 'Opakovať',
    fullStrokeEraser: 'Guma s plným ťahom',
    selectPenType: 'Typ pera',
    selectShape: 'Tvar',
    pickColorFromScreen: 'Vybrať farbu z obrazovky',
    clickToPickColorAnnouncement: 'Kliknutím na obrazovku vyberte farbu',
    colorSelectionCanceledAnnouncement: 'Výber farby zrušený',
    selectionTool__lassoSelect: 'Výber voľného tvaru',
    selectionTool__lassoSelect__help: 'Ak je táto funkcia zapnutá, ťahanie vytvorí voľný tvar (laso) výberu.',
    selectionToolKeyboardShortcuts: 'Nástroj na výber: Pomocou klávesov so šípkami môžete presunúť vybrané položky, malými/veľkými písmenami „i“ a „o“ môžete zmeniť veľkosť.',
    documentProperties: 'Strana',
    backgroundColor: 'Farba pozadia',
    imageWidthOption: 'Šírka',
    imageHeightOption: 'Výška',
    useGridOption: 'Mriežka',
    enableAutoresizeOption: 'Automatická zmena veľkosti',
    toggleOverflow: 'Viac',
    about: 'O aplikácii',
    inputStabilization: 'Stabilizácia',
    strokeAutocorrect: 'Automatická oprava',
    pressureSensitivity: 'Tlak',
    touchPanning: 'Posúvanie dotykom',
    roundedTipPen: 'Okrúhle',
    roundedTipPen2: 'Viacčiarové',
    flatTipPen: 'Ploché',
    arrowPen: 'Šípka',
    linePen: 'Čiara',
    outlinedRectanglePen: 'Obrys obdĺžnika',
    filledRectanglePen: 'Plný obdĺžnik',
    outlinedCirclePen: 'Kružnica',
    lockRotation: 'Zamknúť otáčanie',
    paste: 'Vložiť',
    errorImageHasZeroSize: 'Chyba: Obrázok má nulovú veľkosť',
    describeTheImage: 'Popis obrázku',
    fileInput__loading: 'Načítavanie...',
    fileInput__andNMoreFiles: (n) => `(...${n} ďalších)`,
    penDropdown__baseHelpText: 'Tento nástroj kreslí tvary alebo voľné čiary.',
    penDropdown__colorHelpText: 'Zmení farbu pera',
    penDropdown__thicknessHelpText: 'Mení hrúbku ťahov nakreslených perom.',
    penDropdown__penTypeHelpText: 'Zmení štýl pera.\n\nMôžete si vybrať buď štýl „pero“, alebo „tvar“. Výberom štýlu „pero“ sa kreslia voľné čiary. Výberom štýlu „tvar“ sa kreslia tvary.',
    penDropdown__autocorrectHelpText: 'Prevedie približné voľné čiary a obdĺžniky na dokonalé.\n\nPero musí byť držané nehybne na konci ťahu, aby sa spustila oprava.',
    penDropdown__stabilizationHelpText: 'Kreslí hladšie ťahy.\n\nPridáva tiež krátke oneskorenie medzi pohybom myši/stylusu a ťahom.',
    penDropdown__pressureSensitivityHelpText: 'Pri použití kompatibilného zariadenia, napríklad stylusu, mení hrúbku ťahov podľa sily stlačenia.',
    handDropdown__baseHelpText: 'Tento nástroj je zodpovedný za posúvanie, otáčanie a zväčšovanie editora.',
    handDropdown__zoomInHelpText: 'Priblížiť.',
    handDropdown__zoomOutHelpText: 'Oddialiť.',
    handDropdown__resetViewHelpText: 'Obnoví úroveň priblíženia na 100 % a vynuluje posúvanie.',
    handDropdown__zoomDisplayHelpText: 'Zobrazí aktuálnu úroveň priblíženia. 100 % zobrazuje obrázok v jeho skutočnej veľkosti.',
    handDropdown__touchPanningHelpText: 'Keď je táto funkcia zapnutá, gestá dotykovej obrazovky posúvajú obrázok, a nevyberajú ho ani nekreslia.',
    handDropdown__lockRotationHelpText: 'Ak je táto funkcia zapnutá, zabraňuje dotykovým gestám otáčať obrazovku.',
    eraserDropdown__baseHelpText: 'Tento nástroj odstraňuje ťahy, obrázky a text pod kurzorom.',
    eraserDropdown__thicknessHelpText: 'Zmení veľkosť gumy.',
    eraserDropdown__fullStrokeEraserHelpText: '`V režime plného ťahu sa vymažú celé tvary.\n\nKeď nie je v režime plného ťahu, tvary sa môžu byť čiastočne vymazané.`',
    selectionDropdown__baseHelpText: 'Vyberá obsah a manipuluje s výberom',
    selectionDropdown__resizeToHelpText: 'Oreže kresbu na veľkosť toho, čo je aktuálne vybrané.\n\nAk je zapnutá automatická zmena veľkosti, bude táto funkcia vypnutá.',
    selectionDropdown__deleteHelpText: 'Vymaže vybrané položky.',
    selectionDropdown__duplicateHelpText: 'Vytvorí kópiu vybraných položiek.',
    selectionDropdown__changeColorHelpText: 'Zmení farbu vybraných položiek.',
    pageDropdown__baseHelpText: 'Ovláda farbu, vzor a veľkosť pozadia kresliaceho plátna.',
    pageDropdown__backgroundColorHelpText: 'Zmení farbu pozadia kresliaceho plátna.',
    pageDropdown__gridCheckboxHelpText: 'Zapne/vypne vzor mriežky na pozadí.',
    pageDropdown__autoresizeCheckboxHelpText: 'Pokiaľ je označené, stránka sa zväčší tak, aby sa prispôsobila kresbe.\n\nKeď nie je označené, stránka je viditeľná a jej veľkosť sa dá nastaviť ručne.',
    pageDropdown__aboutButtonHelpText: 'Zobrazí verziu, ladenie a ďalšie informácie.',
    colorPickerPipetteHelpText: 'Vyberie farbu z obrazovky.',
    colorPickerToggleHelpText: 'Otvorí/zatvorí výber farieb.',
    closeSidebar: (toolName) => `Zatvoriť bočný panel pre ${toolName}`,
    dropdownShown: (toolName) => `Ponuka pre ${toolName} zobrazená`,
    dropdownHidden: (toolName) => `Ponuka pre ${toolName} skrytá`,
    zoomLevel: (zoomPercent) => `Priblíženie: ${zoomPercent}%`,
    colorChangedAnnouncement: (color) => `Farba zmenená na ${color}`,
    imageSize: (size, units) => `Veľkosť obrázka: ${size} ${units}`,
    imageLoadError: (message) => `Chyba pri načítavaní obrázka: ${message}`,
    penTool: (penId) => `Pero ${penId}`,
    selectionTool: 'Výber',
    selectAllTool: 'Skratka pre výber všetkých',
    eraserTool: 'Guma',
    touchPanTool: 'Posúvanie dotykom',
    twoFingerPanZoomTool: 'Posun a priblíženie',
    undoRedoTool: 'Späť/Opakovať',
    rightClickDragPanTool: 'Ťahanie pravým tlačidlom myši',
    pipetteTool: 'Vybrať farbu z obrazovky',
    keyboardPanZoom: 'Klávesové skratky pre posúvanie/priblíženie',
    selectionMenu__show: 'Zobraziť ponuku výberu',
    selectionMenu__copyToClipboard: 'Kopírovať do schránky',
    selectionMenu__duplicate: 'Duplikovať',
    selectionMenu__delete: 'Vymazať',
    selectionMenu__paste: 'Vložiť',
    copyPasteError__heading: 'Kopírovať/vložiť',
    copyPasteError__description: 'Niečo sa pokazilo - tento nástroj nemusí mať prístup k schránke.',
    copyPasteError__errorDetails: 'Zobraziť chybu',
    copyPasteError__pasteRetry: 'Ak chcete opakovať pokus, vložte ho do nižšie uvedeného vstupného poľa:',
    copyPasteError__copyRetry: 'Ak chcete opakovať pokus, skopírujte text do vstupného poľa nižšie:',
    copyPasteError__copyMe: 'Skopíruj ma!',
    autocorrectedTo: (strokeDescription) => `Automaticky opravené na ${strokeDescription}`,
    autocorrectionCanceled: 'Automatická oprava zrušená',
    enterTextToInsert: 'Text, ktorý sa má vložiť',
    changeTool: 'Zmeniť nástroj',
    findLabel: 'Hľadať',
    toNextMatch: 'Ďalšie',
    closeDialog: 'Zavrieť',
    findDialogShown: 'Dialógové okno vyhľadávania zobrazené',
    findDialogHidden: 'Dialógové okno vyhľadávania je skryté',
    copied: (count) => `Skopírovaných ${count} položiek`,
    pasted: (count) => `Vložených ${count} položiek`,
    toolEnabledAnnouncement: (toolName) => `${toolName} zapnuté`,
    toolDisabledAnnouncement: (toolName) => `${toolName} vypnuté`,
    resizeOutputCommand: (newSize) => `Zmenená veľkosť obrázka na ${newSize.w}x${newSize.h}`,
    enabledAutoresizeOutputCommand: 'Automatická zmena veľkosti výstupu je povolená',
    disabledAutoresizeOutputCommand: 'Automatická zmena veľkosti výstupu je zakázaná',
    addComponentAction: (componentDescription) => `Pridané ${componentDescription}`,
    eraseAction: (componentDescription, numElems) => `Vymazané ${numElems} ${componentDescription}`,
    duplicateAction: (componentDescription, numElems) => `Duplikované ${numElems} ${componentDescription}`,
    elements: 'Prvky',
    erasedNoElements: 'Nič sa nevymazalo.',
    duplicatedNoElements: 'Nič sa neduplikovalo.',
    rotatedBy: (degrees) => `Otočené o ${Math.abs(degrees)} stupňov ${degrees < 0 ? 'clockwise' : 'counter-clockwise'}`,
    movedLeft: 'Presunuté doľava',
    movedUp: 'Presunuté hore',
    movedDown: 'Presunuté dole',
    movedRight: 'Presunuté doprava',
    zoomedOut: 'Oddialené',
    zoomedIn: 'Priblížené',
    andNMoreCommands: (count) => `A ${count} ďalších príkazov.`,
    unlabeledImageNode: 'Obrázok bez označenia',
    stroke: 'Ťah',
    svgObject: 'Objekt SVG',
    emptyBackground: 'Prázdne pozadie',
    gridBackground: 'Pozadie s mriežkou',
    filledBackgroundWithColor: (color) => `Vyplnené pozadie (${color})`,
    text: (text) => `Textový objekt: ${text}`,
    imageNode: (label) => `Obrázok: ${label}`,
    pathNodeCount: (count) => `Viditeľných je ${count} objektov ciest.`,
    textNodeCount: (count) => `Viditeľných je ${count} textových uzlov.`,
    imageNodeCount: (nodeCount) => `Viditeľných je ${nodeCount} obrazových uzlov.`,
    rerenderAsText: 'Opätovne vykresliť ako text.',
    accessibilityInputInstructions: 'Pomocou tlačidla „t“ prečítate obsah zobrazovacieho okna ako text. Pomocou klávesov so šípkami pohybujte zobrazovacím oknom, kliknutím a ťahaním kreslite ťahy. Stlačením tlačidla „w“ priblížite a stlačením tlačidla „s“ oddialite pohľad.',
    loading: (percentage) => `Načítava sa ${percentage}%...`,
    imageEditor: 'Editor obrázkov',
    doneLoading: 'Načítanie dokončené',
    softwareLibraries: 'Knižnice',
    developerInformation: 'Informácie pre vývojárov',
};
exports.default = localization;
