"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchingLocalizationTable = exports.allLocales = void 0;
const localization_1 = require("../localization");
const zh_1 = __importDefault(require("./zh"));
const de_1 = __importDefault(require("./de"));
const en_1 = __importDefault(require("./en"));
const es_1 = __importDefault(require("./es"));
const sk_1 = __importDefault(require("./sk"));
exports.allLocales = {
    de: de_1.default,
    en: en_1.default,
    es: es_1.default,
    sk: sk_1.default,
    zh: zh_1.default,
};
// [locale]: A string in the format languageCode_Region or just languageCode. For example, en_US.
const languageFromLocale = (locale) => {
    const matches = /^(\w+)[_-](\w+)$/.exec(locale);
    if (!matches) {
        // If not in languageCode_region format, the locale should be the
        // languageCode. Return that.
        return locale;
    }
    return matches[1];
};
/**
 * Return the localization table in `localizationTables` that best matches
 * the list of `userLocales`. If there is no matching language, returns
 * `defaultLocalizationTable`.
 */
const matchingLocalizationTable = (userLocales, localizationTables, defaultLocalizationTable) => {
    let prevLanguage;
    for (const locale of userLocales) {
        const language = languageFromLocale(locale);
        // If the specific localization of the language is not available, but
        // a localization for the language is,
        if (prevLanguage && language !== prevLanguage) {
            if (prevLanguage in localizationTables) {
                return localizationTables[prevLanguage];
            }
        }
        // If the full locale (e.g. en_US) is available,
        if (locale in localizationTables) {
            return localizationTables[locale];
        }
        prevLanguage = language;
    }
    if (prevLanguage && prevLanguage in localizationTables) {
        return localizationTables[prevLanguage];
    }
    else {
        return defaultLocalizationTable;
    }
};
exports.matchingLocalizationTable = matchingLocalizationTable;
/**
 * Returns a localization table for the `Editor` that matches
 * the user's current locale.
 *
 * Returns the default localization table if no appropriate localization
 * exists.
 */
const getLocalizationTable = (userLocales) => {
    userLocales ??= navigator.languages;
    return (0, exports.matchingLocalizationTable)(userLocales, exports.allLocales, localization_1.defaultEditorLocalization);
};
exports.default = getLocalizationTable;
