import { EditorLocalization } from '../localization';
export declare const allLocales: Record<string, EditorLocalization>;
/**
 * Return the localization table in `localizationTables` that best matches
 * the list of `userLocales`. If there is no matching language, returns
 * `defaultLocalizationTable`.
 */
export declare const matchingLocalizationTable: <T>(userLocales: readonly string[], localizationTables: Record<string, T>, defaultLocalizationTable: T) => T;
/**
 * Returns a localization table for the `Editor` that matches
 * the user's current locale.
 *
 * Returns the default localization table if no appropriate localization
 * exists.
 */
declare const getLocalizationTable: (userLocales?: readonly string[]) => EditorLocalization;
export default getLocalizationTable;
