"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultEditorLocalization = void 0;
const localization_1 = require("./commands/localization");
const localization_2 = require("./components/localization");
const localization_3 = require("./rendering/localization");
const localization_4 = require("./toolbar/localization");
const localization_5 = require("./tools/localization");
exports.defaultEditorLocalization = {
    ...localization_4.defaultToolbarLocalization,
    ...localization_5.defaultToolLocalization,
    ...localization_1.defaultCommandLocalization,
    ...localization_2.defaultComponentLocalization,
    ...localization_3.defaultTextRendererLocalization,
    accessibilityInputInstructions: [
        'Press "t" to read the contents of the viewport as text.',
        'Use the arrow keys to move the viewport, click and drag to draw strokes.',
        'Press "w" to zoom in and "s" to zoom out.',
    ].join(' '),
    loading: (percentage) => `Loading ${percentage}%...`,
    imageEditor: 'Image Editor',
    doneLoading: 'Done loading',
    undoAnnouncement: (commandDescription) => `Undid ${commandDescription}`,
    redoAnnouncement: (commandDescription) => `Redid ${commandDescription}`,
    softwareLibraries: 'Libraries',
    developerInformation: 'Developer information',
};
