"use strict";
/**
 * The main entrypoint for the NPM package. Everything exported by this file
 * is available through the [`js-draw` package](https://www.npmjs.com/package/js-draw).
 *
 * ## Example
 *
 * [[include:doc-pages/inline-examples/main-js-draw-example.md]]
 *
 * @see
 * - {@link Editor}
 * - {@link Editor.loadFromSVG}
 * - {@link AbstractToolbar.addActionButton }
 * - {@link EditorSettings}
 *
 * @packageDocumentation
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HTMLToolbar = exports.AbstractToolbar = exports.Editor = exports.__js_draw__version = exports.UndoRedoHistory = exports.PointerDevice = exports.Pointer = exports.EventDispatcher = exports.Viewport = exports.SVGLoader = exports.matchingLocalizationTable = exports.getLocalizationTable = void 0;
const Editor_1 = __importDefault(require("./Editor"));
exports.Editor = Editor_1.default;
__exportStar(require("./image/lib"), exports);
__exportStar(require("./types"), exports);
__exportStar(require("./inputEvents"), exports);
var getLocalizationTable_1 = require("./localizations/getLocalizationTable");
Object.defineProperty(exports, "getLocalizationTable", { enumerable: true, get: function () { return __importDefault(getLocalizationTable_1).default; } });
Object.defineProperty(exports, "matchingLocalizationTable", { enumerable: true, get: function () { return getLocalizationTable_1.matchingLocalizationTable; } });
__exportStar(require("./localization"), exports);
var SVGLoader_1 = require("./SVGLoader/SVGLoader");
Object.defineProperty(exports, "SVGLoader", { enumerable: true, get: function () { return __importDefault(SVGLoader_1).default; } });
var Viewport_1 = require("./Viewport");
Object.defineProperty(exports, "Viewport", { enumerable: true, get: function () { return __importDefault(Viewport_1).default; } });
__exportStar(require("@js-draw/math"), exports);
__exportStar(require("./components/lib"), exports);
__exportStar(require("./commands/lib"), exports);
__exportStar(require("./tools/lib"), exports);
__exportStar(require("./toolbar/lib"), exports);
__exportStar(require("./rendering/lib"), exports);
__exportStar(require("./testing/lib"), exports);
__exportStar(require("./shortcuts/lib"), exports);
var EventDispatcher_1 = require("./EventDispatcher");
Object.defineProperty(exports, "EventDispatcher", { enumerable: true, get: function () { return __importDefault(EventDispatcher_1).default; } });
var Pointer_1 = require("./Pointer");
Object.defineProperty(exports, "Pointer", { enumerable: true, get: function () { return __importDefault(Pointer_1).default; } });
Object.defineProperty(exports, "PointerDevice", { enumerable: true, get: function () { return Pointer_1.PointerDevice; } });
var UndoRedoHistory_1 = require("./UndoRedoHistory");
Object.defineProperty(exports, "UndoRedoHistory", { enumerable: true, get: function () { return __importDefault(UndoRedoHistory_1).default; } });
__exportStar(require("./util/lib"), exports);
// @internal
var version_1 = require("./version");
Object.defineProperty(exports, "__js_draw__version", { enumerable: true, get: function () { return __importDefault(version_1).default; } });
const AbstractToolbar_1 = __importDefault(require("./toolbar/AbstractToolbar"));
exports.AbstractToolbar = AbstractToolbar_1.default;
exports.HTMLToolbar = AbstractToolbar_1.default;
exports.default = Editor_1.default;
