"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPointerEvt = exports.keyPressEventFromHTMLEvent = exports.keyUpEventFromHTMLEvent = exports.InputEvtType = void 0;
var InputEvtType;
(function (InputEvtType) {
    InputEvtType[InputEvtType["PointerDownEvt"] = 0] = "PointerDownEvt";
    InputEvtType[InputEvtType["PointerMoveEvt"] = 1] = "PointerMoveEvt";
    InputEvtType[InputEvtType["PointerUpEvt"] = 2] = "PointerUpEvt";
    InputEvtType[InputEvtType["GestureCancelEvt"] = 3] = "GestureCancelEvt";
    InputEvtType[InputEvtType["WheelEvt"] = 4] = "WheelEvt";
    InputEvtType[InputEvtType["KeyPressEvent"] = 5] = "KeyPressEvent";
    InputEvtType[InputEvtType["KeyUpEvent"] = 6] = "KeyUpEvent";
    InputEvtType[InputEvtType["CopyEvent"] = 7] = "CopyEvent";
    InputEvtType[InputEvtType["PasteEvent"] = 8] = "PasteEvent";
    InputEvtType[InputEvtType["ContextMenu"] = 9] = "ContextMenu";
})(InputEvtType || (exports.InputEvtType = InputEvtType = {}));
// Constructor
const keyEventFromHTMLEvent = (kind, event) => {
    return {
        kind,
        key: event.key,
        code: event.code,
        ctrlKey: event.ctrlKey || event.metaKey,
        altKey: event.altKey,
        shiftKey: event.shiftKey,
    };
};
const keyUpEventFromHTMLEvent = (event) => {
    return keyEventFromHTMLEvent(InputEvtType.KeyUpEvent, event);
};
exports.keyUpEventFromHTMLEvent = keyUpEventFromHTMLEvent;
const keyPressEventFromHTMLEvent = (event) => {
    return keyEventFromHTMLEvent(InputEvtType.KeyPressEvent, event);
};
exports.keyPressEventFromHTMLEvent = keyPressEventFromHTMLEvent;
const isPointerEvt = (event) => {
    return (event.kind === InputEvtType.PointerDownEvt ||
        event.kind === InputEvtType.PointerMoveEvt ||
        event.kind === InputEvtType.PointerUpEvt);
};
exports.isPointerEvt = isPointerEvt;
