import Pointer from './Pointer';
import { Point2, Vec3 } from '@js-draw/math';
export type HTMLPointerEventName = 'pointerdown' | 'pointermove' | 'pointerup' | 'pointercancel';
export type HTMLPointerEventFilter = (eventName: HTMLPointerEventName, event: PointerEvent) => boolean;
export interface PointerEvtListener {
    onPointerDown(event: PointerEvt): boolean;
    onPointerMove(event: PointerEvt): void;
    onPointerUp(event: PointerEvt): void;
    onGestureCancel(): void;
}
export declare enum InputEvtType {
    PointerDownEvt = 0,
    PointerMoveEvt = 1,
    PointerUpEvt = 2,
    GestureCancelEvt = 3,
    WheelEvt = 4,
    KeyPressEvent = 5,
    KeyUpEvent = 6,
    CopyEvent = 7,
    PasteEvent = 8,
    ContextMenu = 9
}
export interface WheelEvt {
    readonly kind: InputEvtType.WheelEvt;
    readonly delta: Vec3;
    readonly screenPos: Point2;
}
interface BaseKeyEvent {
    readonly key: string;
    readonly code: string;
    readonly ctrlKey: boolean | undefined;
    readonly altKey: boolean | undefined;
    readonly shiftKey: boolean | undefined;
}
/**
 * Represents a keydown or auto-repeated keydown event.
 *
 * Use {@link keyPressEventFromHTMLEvent} where possible rather than
 * constructing directly (required properties may change between minor
 * releases).
 */
export interface KeyPressEvent extends BaseKeyEvent {
    readonly kind: InputEvtType.KeyPressEvent;
}
/**
 * Represents a key release or auto-repeated key releae event.
 *
 * Use {@link keyUpEventFromHTMLEvent} where possible rather than
 * constructing directly (required properties may change between minor
 * releases).
 */
export interface KeyUpEvent extends BaseKeyEvent {
    readonly kind: InputEvtType.KeyUpEvent;
}
export interface CopyEvent {
    readonly kind: InputEvtType.CopyEvent;
    setData(mime: string, data: string | Promise<Blob>): void;
}
export interface PasteEvent {
    readonly kind: InputEvtType.PasteEvent;
    readonly data: string;
    readonly mime: string;
}
export interface GestureCancelEvt {
    readonly kind: InputEvtType.GestureCancelEvt;
}
interface PointerEvtBase {
    readonly current: Pointer;
    readonly allPointers: Pointer[];
}
export interface PointerDownEvt extends PointerEvtBase {
    readonly kind: InputEvtType.PointerDownEvt;
}
export interface PointerMoveEvt extends PointerEvtBase {
    readonly kind: InputEvtType.PointerMoveEvt;
}
export interface PointerUpEvt extends PointerEvtBase {
    readonly kind: InputEvtType.PointerUpEvt;
}
export interface ContextMenuEvt {
    readonly kind: InputEvtType.ContextMenu;
    readonly screenPos: Point2;
    readonly canvasPos: Point2;
}
/**
 * An internal `js-draw` pointer event type.
 *
 * This **is not** the same as a DOM pointer event.
 */
export type PointerEvt = PointerDownEvt | PointerMoveEvt | PointerUpEvt;
/** The type of any internal {@link PointerEvt} record. */
export type PointerEvtType = InputEvtType.PointerDownEvt | InputEvtType.PointerMoveEvt | InputEvtType.PointerUpEvt;
/**
 * An internal `js-draw` input event type.
 *
 * These are not DOM events.
 */
export type InputEvt = KeyPressEvent | KeyUpEvent | WheelEvt | GestureCancelEvt | PointerEvt | CopyEvent | PasteEvent | ContextMenuEvt;
export declare const keyUpEventFromHTMLEvent: (event: KeyboardEvent) => KeyUpEvent;
export declare const keyPressEventFromHTMLEvent: (event: KeyboardEvent) => KeyPressEvent;
export declare const isPointerEvt: (event: InputEvt) => event is PointerEvt;
export {};
