"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.editorImageToSVGAsync = exports.editorImageToSVGSync = void 0;
const math_1 = require("@js-draw/math");
const SVGRenderer_1 = __importDefault(require("../../rendering/renderers/SVGRenderer"));
const SVGLoader_1 = require("../../SVGLoader/SVGLoader");
const adjustExportedSVGSize_1 = __importDefault(require("./adjustExportedSVGSize"));
const toSVGInternal = (image, renderFunction, options) => {
    const importExportViewport = image.getImportExportViewport().getTemporaryClone();
    // If the rectangle has zero width or height, its size can't be increased
    // -- set its size to the minimum.
    if (options?.minDimension) {
        const originalRect = importExportViewport.visibleRect;
        let rect = originalRect;
        if (rect.w <= 0) {
            rect = new math_1.Rect2(rect.x, rect.y, options.minDimension, rect.h);
        }
        if (rect.h <= 0) {
            rect = new math_1.Rect2(rect.x, rect.y, rect.w, options.minDimension);
        }
        if (!rect.eq(originalRect)) {
            importExportViewport.updateScreenSize(rect.size);
        }
    }
    const { element: result, renderer } = SVGRenderer_1.default.fromViewport(importExportViewport, {
        sanitize: options.sanitize ?? false,
        useViewBoxForPositioning: true,
    });
    // Use a callback rather than async/await to allow this function to create
    // both sync and async render functions
    renderFunction(renderer, () => {
        if (image.getAutoresizeEnabled()) {
            result.classList.add(SVGLoader_1.svgLoaderAutoresizeClassName);
        }
        else {
            result.classList.remove(SVGLoader_1.svgLoaderAutoresizeClassName);
        }
        const exportRect = importExportViewport.visibleRect;
        (0, adjustExportedSVGSize_1.default)(result, exportRect, options);
        return result;
    });
    return result;
};
const editorImageToSVGSync = (image, options) => {
    return toSVGInternal(image, (renderer, onComplete) => {
        image.renderAll(renderer);
        onComplete();
    }, options);
};
exports.editorImageToSVGSync = editorImageToSVGSync;
const editorImageToSVGAsync = (image, preRenderComponent, options) => {
    return new Promise((resolve) => {
        toSVGInternal(image, async (renderer, onComplete) => {
            await image.renderAllAsync(renderer, preRenderComponent);
            const result = onComplete();
            resolve(result);
        }, options);
    });
};
exports.editorImageToSVGAsync = editorImageToSVGAsync;
