"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const math_1 = require("@js-draw/math");
// @internal
const adjustExportedSVGSize = (svg, exportRect, options) => {
    // Adjust the width/height as necessary
    let width = exportRect.w;
    let height = exportRect.h;
    if (options?.minDimension && width < options.minDimension) {
        const newWidth = options.minDimension;
        height *= newWidth / (width || 1);
        width = newWidth;
    }
    if (options?.minDimension && height < options.minDimension) {
        const newHeight = options.minDimension;
        width *= newHeight / (height || 1);
        height = newHeight;
    }
    svg.setAttribute('width', (0, math_1.toRoundedString)(width));
    svg.setAttribute('height', (0, math_1.toRoundedString)(height));
};
exports.default = adjustExportedSVGSize;
