"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Returns the description of all given elements, if identical, otherwise,
// returns null.
exports.default = (localizationTable, elems) => {
    if (elems.length === 0) {
        return null;
    }
    const description = elems[0].description(localizationTable);
    for (const elem of elems) {
        if (elem.description(localizationTable) !== description) {
            return null;
        }
    }
    return description;
};
