import { Vec2, Rect2 } from '@js-draw/math';
import { StrokeDataPoint } from '../../types';
export interface Curve {
    startPoint: Vec2;
    startWidth: number;
    controlPoint: Vec2;
    endWidth: number;
    endPoint: Vec2;
}
type OnCurveAddedCallback = (curve: Curve | null) => void;
export declare class StrokeSmoother {
    private startPoint;
    private minFitAllowed;
    private maxFitAllowed;
    private onCurveAdded;
    private isFirstSegment;
    private buffer;
    private lastPoint;
    private lastExitingVec;
    private currentCurve;
    private curveStartWidth;
    private curveEndWidth;
    private momentum;
    private bbox;
    constructor(startPoint: StrokeDataPoint, minFitAllowed: number, maxFitAllowed: number, onCurveAdded: OnCurveAddedCallback);
    getBBox(): Rect2;
    preview(): Curve | null;
    private approxCurrentCurveLength;
    finalizeCurrentCurve(): void;
    private currentSegmentToPath;
    private computeExitingVec;
    addPoint(newPoint: StrokeDataPoint): void;
}
export default StrokeSmoother;
