import { Rect2 } from '@js-draw/math';
import AbstractRenderer from '../../rendering/renderers/AbstractRenderer';
import { StrokeDataPoint } from '../../types';
import Viewport from '../../Viewport';
import AbstractComponent from '../AbstractComponent';
import { ComponentBuilder, ComponentBuilderFactory } from './types';
/**
 * Creates filled rectangles with sharp corners.
 *
 * Example:
 * [[include:doc-pages/inline-examples/changing-pen-types.md]]
 */
export declare const makeFilledRectangleBuilder: ComponentBuilderFactory;
/**
 * Creates outlined rectangles with sharp corners.
 *
 * Example:
 * [[include:doc-pages/inline-examples/changing-pen-types.md]]
 */
export declare const makeOutlinedRectangleBuilder: ComponentBuilderFactory;
export default class RectangleBuilder implements ComponentBuilder {
    private readonly startPoint;
    private filled;
    private viewport;
    private endPoint;
    constructor(startPoint: StrokeDataPoint, filled: boolean, viewport: Viewport);
    getBBox(): Rect2;
    private buildPreview;
    build(): AbstractComponent;
    preview(renderer: AbstractRenderer): void;
    addPoint(point: StrokeDataPoint): void;
}
