import AbstractRenderer from '../../rendering/renderers/AbstractRenderer';
import { Rect2 } from '@js-draw/math';
import Stroke from '../Stroke';
import Viewport from '../../Viewport';
import { StrokeDataPoint } from '../../types';
import { ComponentBuilder, ComponentBuilderFactory } from './types';
export declare const makePressureSensitiveFreehandLineBuilder: ComponentBuilderFactory;
export default class PressureSensitiveFreehandLineBuilder implements ComponentBuilder {
    private startPoint;
    private minFitAllowed;
    private viewport;
    private isFirstSegment;
    private pathStartConnector;
    private mostRecentConnector;
    private nextCurveStartConnector;
    private upperSegments;
    private lowerSegments;
    private lastUpperBezier;
    private lastLowerBezier;
    private parts;
    private curveFitter;
    private curveStartWidth;
    private bbox;
    constructor(startPoint: StrokeDataPoint, minFitAllowed: number, maxFitAllowed: number, viewport: Viewport);
    getBBox(): Rect2;
    private getRenderingStyle;
    private previewCurrentPath;
    private previewFullPath;
    preview(renderer: AbstractRenderer): void;
    build(): Stroke;
    private roundPoint;
    private shouldStartNewSegment;
    private getCurrentRadius;
    private addCurve;
    private segmentToPath;
    addPoint(newPoint: StrokeDataPoint): void;
}
