"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeLineBuilder = void 0;
const math_1 = require("@js-draw/math");
const RenderablePathSpec_1 = require("../../rendering/RenderablePathSpec");
const Stroke_1 = __importDefault(require("../Stroke"));
const makeSnapToGridAutocorrect_1 = __importDefault(require("./autocorrect/makeSnapToGridAutocorrect"));
/**
 * Creates a stroke builder that generates filled lines.
 *
 * Example:
 * [[include:doc-pages/inline-examples/changing-pen-types.md]]
 */
exports.makeLineBuilder = (0, makeSnapToGridAutocorrect_1.default)((initialPoint, viewport) => {
    return new LineBuilder(initialPoint, viewport);
});
class LineBuilder {
    constructor(startPoint, viewport) {
        this.startPoint = startPoint;
        this.viewport = viewport;
        this.endPoint = startPoint;
    }
    getBBox() {
        const preview = this.buildPreview();
        return preview.getBBox();
    }
    buildPreview() {
        const startPoint = this.startPoint.pos;
        const endPoint = this.endPoint.pos;
        const toEnd = endPoint.minus(startPoint).normalized();
        const startSize = this.startPoint.width / 2;
        const endSize = this.endPoint.width / 2;
        const lineNormal = toEnd.orthog();
        const scaledStartNormal = lineNormal.times(startSize);
        const scaledEndNormal = lineNormal.times(endSize);
        const strokeStartPoint = startPoint.minus(scaledStartNormal);
        const path = new math_1.Path(strokeStartPoint, [
            {
                kind: math_1.PathCommandType.LineTo,
                point: startPoint.plus(scaledStartNormal),
            },
            {
                kind: math_1.PathCommandType.LineTo,
                point: endPoint.plus(scaledEndNormal),
            },
            {
                kind: math_1.PathCommandType.LineTo,
                point: endPoint.minus(scaledEndNormal),
            },
            {
                kind: math_1.PathCommandType.LineTo,
                point: startPoint.minus(scaledStartNormal),
            },
        ]).mapPoints((point) => this.viewport.roundPoint(point));
        const preview = new Stroke_1.default([(0, RenderablePathSpec_1.pathToRenderable)(path, { fill: this.startPoint.color })]);
        return preview;
    }
    build() {
        return this.buildPreview();
    }
    preview(renderer) {
        this.buildPreview().render(renderer);
    }
    addPoint(point) {
        this.endPoint = point;
    }
}
exports.default = LineBuilder;
