import AbstractRenderer from '../../rendering/renderers/AbstractRenderer';
import RenderablePathSpec from '../../rendering/RenderablePathSpec';
import { Rect2, Color4 } from '@js-draw/math';
import Stroke from '../Stroke';
import Viewport from '../../Viewport';
import { StrokeDataPoint } from '../../types';
import { ComponentBuilder, ComponentBuilderFactory } from './types';
import RenderingStyle from '../../rendering/RenderingStyle';
/**
 * Creates a stroke builder that draws freehand lines.
 *
 * Example:
 * [[include:doc-pages/inline-examples/changing-pen-types.md]]
 */
export declare const makeFreehandLineBuilder: ComponentBuilderFactory;
export default class FreehandLineBuilder implements ComponentBuilder {
    private startPoint;
    private minFitAllowed;
    private viewport;
    private isFirstSegment;
    private parts;
    private curveFitter;
    private bbox;
    private averageWidth;
    private widthAverageNumSamples;
    constructor(startPoint: StrokeDataPoint, minFitAllowed: number, maxFitAllowed: number, viewport: Viewport);
    getBBox(): Rect2;
    protected getRenderingStyle(): RenderingStyle;
    inkTrailStyle(): {
        color: Color4;
        width: number;
    };
    protected previewCurrentPath(): RenderablePathSpec | null;
    protected previewFullPath(): RenderablePathSpec[] | null;
    private previewStroke;
    preview(renderer: AbstractRenderer): void;
    build(): Stroke;
    private getMinFit;
    private roundPoint;
    private roundDistance;
    private curveToPathCommands;
    private addCurve;
    addPoint(newPoint: StrokeDataPoint): void;
}
