"use strict";
//
// Stores objects loaded from an SVG that aren't recognised by the editor.
// @internal
// @packageDocumentation
//
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const math_1 = require("@js-draw/math");
const SVGRenderer_1 = __importDefault(require("../rendering/renderers/SVGRenderer"));
const AbstractComponent_1 = __importStar(require("./AbstractComponent"));
const componentId = 'unknown-svg-object';
class UnknownSVGObject extends AbstractComponent_1.default {
    constructor(svgObject) {
        super(componentId);
        this.svgObject = svgObject;
        this.contentBBox = math_1.Rect2.of(svgObject.getBoundingClientRect());
    }
    render(canvas, _visibleRect) {
        if (!(canvas instanceof SVGRenderer_1.default)) {
            // Don't draw unrenderable objects if we can't
            return;
        }
        canvas.startObject(this.contentBBox);
        canvas.drawSVGElem(this.svgObject);
        canvas.endObject(this.getLoadSaveData());
    }
    intersects(lineSegment) {
        return this.contentBBox.getEdges().some((edge) => edge.intersection(lineSegment) !== null);
    }
    applyTransformation(_affineTransfm) { }
    isSelectable() {
        return false;
    }
    getSizingMode() {
        // This component can be shown anywhere (it won't be
        // visible to the user, it just needs to be saved with
        // the image).
        return AbstractComponent_1.ComponentSizingMode.Anywhere;
    }
    createClone() {
        return new UnknownSVGObject(this.svgObject.cloneNode(true));
    }
    description(localization) {
        return localization.svgObject;
    }
    serializeToJSON() {
        return JSON.stringify({
            html: this.svgObject.outerHTML,
        });
    }
}
exports.default = UnknownSVGObject;
// null: Do not deserialize UnknownSVGObjects.
AbstractComponent_1.default.registerComponent(componentId, null);
