import { LineSegment2, Mat33, Rect2 } from '@js-draw/math';
import AbstractRenderer from '../rendering/renderers/AbstractRenderer';
import AbstractComponent, { ComponentSizingMode } from './AbstractComponent';
import { ImageComponentLocalization } from './localization';
export default class UnknownSVGObject extends AbstractComponent {
    private svgObject;
    protected contentBBox: Rect2;
    constructor(svgObject: SVGElement);
    render(canvas: AbstractRenderer, _visibleRect?: Rect2): void;
    intersects(lineSegment: LineSegment2): boolean;
    protected applyTransformation(_affineTransfm: Mat33): void;
    isSelectable(): boolean;
    getSizingMode(): ComponentSizingMode;
    protected createClone(): AbstractComponent;
    description(localization: ImageComponentLocalization): string;
    protected serializeToJSON(): string | null;
}
