import { LineSegment2, Mat33, Rect2 } from '@js-draw/math';
import AbstractRenderer from '../rendering/renderers/AbstractRenderer';
import AbstractComponent, { ComponentSizingMode } from './AbstractComponent';
import { ImageComponentLocalization } from './localization';
type GlobalAttrsList = Array<[string, string | null]>;
export default class SVGGlobalAttributesObject extends AbstractComponent {
    protected contentBBox: Rect2;
    private readonly attrs;
    constructor(attrs: GlobalAttrsList);
    render(canvas: AbstractRenderer, _visibleRect?: Rect2): void;
    intersects(_lineSegment: LineSegment2): boolean;
    protected applyTransformation(_affineTransfm: Mat33): void;
    isSelectable(): boolean;
    getSizingMode(): ComponentSizingMode;
    protected createClone(): SVGGlobalAttributesObject;
    description(localization: ImageComponentLocalization): string;
    protected serializeToJSON(): string | null;
    static deserializeFromString(this: void, _data: string): AbstractComponent;
}
export {};
