import { Mat33Array, Rect2, Mat33, LineSegment2 } from '@js-draw/math';
import AbstractRenderer, { RenderableImage } from '../rendering/renderers/AbstractRenderer';
import AbstractComponent from './AbstractComponent';
import { ImageComponentLocalization } from './localization';
/**
 * Represents a raster image.
 *
 * **Example: Adding images**:
 * [[include:doc-pages/inline-examples/adding-an-image-and-data-urls.md]]
 */
export default class ImageComponent extends AbstractComponent {
    protected contentBBox: Rect2;
    private image;
    constructor(image: RenderableImage);
    private getImageRect;
    private recomputeBBox;
    /**
     * Load from an image. Waits for the image to load if incomplete.
     *
     * The image, `elem`, must not [taint](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_enabled_image#security_and_tainted_canvases)
     * an HTMLCanvasElement when rendered.
     */
    static fromImage(elem: HTMLImageElement, transform: Mat33): Promise<ImageComponent>;
    render(canvas: AbstractRenderer, _visibleRect?: Rect2): void;
    getProportionalRenderingTime(): number;
    intersects(lineSegment: LineSegment2): boolean;
    protected applyTransformation(affineTransfm: Mat33): void;
    description(localizationTable: ImageComponentLocalization): string;
    getAltText(): string | undefined;
    getURL(): string;
    getTransformation(): Mat33;
    protected createClone(): AbstractComponent;
    protected serializeToJSON(): {
        src: string;
        label: string | undefined;
        width: number;
        height: number;
        transform: Mat33Array;
    };
    static deserializeFromJSON(this: void, data: any): ImageComponent;
}
