import Editor from '../Editor';
import EditorImage from '../image/EditorImage';
import SerializableCommand from '../commands/SerializableCommand';
import { LineSegment2, Mat33, Rect2, Color4 } from '@js-draw/math';
import AbstractRenderer from '../rendering/renderers/AbstractRenderer';
import AbstractComponent, { ComponentSizingMode } from './AbstractComponent';
import { ImageComponentLocalization } from './localization';
import RestyleableComponent, { ComponentStyle } from './RestylableComponent';
export declare enum BackgroundType {
    SolidColor = 0,
    Grid = 1,
    None = 2
}
export declare const imageBackgroundCSSClassName = "js-draw-image-background";
export declare const imageBackgroundGridSizeCSSPrefix = "js-draw-image-background-grid-";
export declare const imageBackgroundNonAutomaticSecondaryColorCSSClassName = "js-draw-image-background-non-automatic-secondary-color";
export declare const backgroundTypeToClassNameMap: {
    1: string;
    0: string;
    2: string;
};
export default class BackgroundComponent extends AbstractComponent implements RestyleableComponent {
    private backgroundType;
    private mainColor;
    protected contentBBox: Rect2;
    private viewportSizeChangeListener;
    private autoresizeChangedListener;
    private fillsScreen;
    private gridSize;
    private gridStrokeWidth;
    private secondaryColor;
    readonly isRestylableComponent: true;
    constructor(backgroundType: BackgroundType, mainColor: Color4);
    static ofGrid(backgroundColor: Color4, gridSize?: number, gridColor?: Color4, gridStrokeWidth?: number): BackgroundComponent;
    getBackgroundType(): BackgroundType;
    getMainColor(): Color4;
    getSecondaryColor(): Color4 | null;
    getGridSize(): number;
    getStyle(): ComponentStyle;
    updateStyle(style: ComponentStyle): SerializableCommand;
    forceStyle(style: ComponentStyle, editor: Editor | null): void;
    onAddToImage(image: EditorImage): void;
    onRemoveFromImage(): void;
    private recomputeBBox;
    private generateGridPath;
    /**
     * @returns this background's bounding box if the screen size is taken into
     * account (which may be necessary if this component is configured to fill the
     * entire screen).
     */
    private getFullBoundingBox;
    render(canvas: AbstractRenderer, visibleRect?: Rect2): void;
    intersects(lineSegment: LineSegment2): boolean;
    isSelectable(): boolean;
    isBackground(): boolean;
    getSizingMode(): ComponentSizingMode;
    protected serializeToJSON(): {
        mainColor: string;
        secondaryColor: string | undefined;
        backgroundType: BackgroundType;
        gridSize: number;
        gridStrokeWidth: number;
    };
    protected applyTransformation(_affineTransfm: Mat33): void;
    description(localizationTable: ImageComponentLocalization): string;
    protected createClone(): AbstractComponent;
    static deserializeFromJSON(this: void, json: any): BackgroundComponent;
}
