"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultCommandLocalization = void 0;
exports.defaultCommandLocalization = {
    updatedViewport: 'Transformed Viewport',
    transformedElements: (elemCount, action) => `Transformed ${elemCount} element${elemCount === 1 ? '' : 's'} (${action})`,
    resizeOutputCommand: (newSize) => `Resized image to ${newSize.w}x${newSize.h}`,
    enabledAutoresizeOutputCommand: 'Enabled output autoresize',
    disabledAutoresizeOutputCommand: 'Disabled output autoresize',
    addComponentAction: (componentDescription) => `Added ${componentDescription}`,
    eraseAction: (componentDescription, numElems) => `Erased ${numElems} ${componentDescription}`,
    duplicateAction: (componentDescription, numElems) => `Duplicated ${numElems} ${componentDescription}`,
    unionOf: (actionDescription, actionCount) => `Union: ${actionCount} ${actionDescription}`,
    inverseOf: (actionDescription) => `Inverse of ${actionDescription}`,
    elements: 'Elements',
    erasedNoElements: 'Erased nothing',
    duplicatedNoElements: 'Duplicated nothing',
    rotatedBy: (degrees) => `Rotated by ${Math.abs(degrees)} degrees ${degrees < 0 ? 'clockwise' : 'counter-clockwise'}`,
    movedLeft: 'Moved left',
    movedUp: 'Moved up',
    movedDown: 'Moved down',
    movedRight: 'Moved right',
    zoomedOut: 'Zoomed out',
    zoomedIn: 'Zoomed in',
    andNMoreCommands: (count) => `And ${count} more commands.`,
    selectedElements: (count) => `Selected ${count} element${count === 1 ? '' : 's'}`,
};
