"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const SerializableCommand_1 = __importDefault(require("./SerializableCommand"));
/**
 * A command that requires a component that may or may not be present in the editor when
 * the command is created.
 */
class UnresolvedSerializableCommand extends SerializableCommand_1.default {
    constructor(commandId, componentID, component) {
        super(commandId);
        this.component = component ?? null;
        this.componentID = componentID;
    }
    resolveComponent(image) {
        if (this.component) {
            return;
        }
        const component = image.lookupElement(this.componentID);
        if (!component) {
            throw new Error(`Unable to resolve component with ID ${this.componentID}`);
        }
        this.component = component;
    }
}
exports.default = UnresolvedSerializableCommand;
