"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _SerializableCommand_commandTypeId;
Object.defineProperty(exports, "__esModule", { value: true });
const Command_1 = __importDefault(require("./Command"));
/**
 * A command that can be serialized to or deserialized from JSON. To allow a command to be deserialized, {@link SerializableCommand.register}
 * must be called for each {@link SerializableCommand}.
 *
 * This is used to [allow collaborative editing](https://github.com/personalizedrefrigerator/js-draw/tree/main/docs/examples/example-collaborative).
 */
class SerializableCommand extends Command_1.default {
    /** @param commandTypeId - A unique identifier for this command. */
    constructor(commandTypeId) {
        super();
        _SerializableCommand_commandTypeId.set(this, void 0);
        if (!(commandTypeId in SerializableCommand.deserializationCallbacks)) {
            throw new Error(`Command ${commandTypeId} must have a registered deserialization callback. To do this, call SerializableCommand.register.`);
        }
        __classPrivateFieldSet(this, _SerializableCommand_commandTypeId, commandTypeId, "f");
    }
    // Convert this command to an object that can be passed to `JSON.stringify`.
    //
    // Do not rely on the stability of the optupt of this function — it can change
    // form without a major version increase.
    serialize() {
        return {
            data: this.serializeToJSON(),
            commandType: __classPrivateFieldGet(this, _SerializableCommand_commandTypeId, "f"),
        };
    }
    // Convert a `string` containing JSON data (or the output of `JSON.parse`) into a
    // `Command`.
    //
    // Implementations should assume that `data` is untrusted.
    static deserialize(data, editor) {
        const json = typeof data === 'string' ? JSON.parse(data) : data;
        const commandType = json.commandType;
        if (!(commandType in SerializableCommand.deserializationCallbacks)) {
            throw new Error(`Unrecognised command type ${commandType}!`);
        }
        return SerializableCommand.deserializationCallbacks[commandType](json.data, editor);
    }
    // Register a deserialization callback. This must be called at least once for every subclass of
    // `SerializableCommand`.
    static register(commandTypeId, deserialize) {
        SerializableCommand.deserializationCallbacks[commandTypeId] = deserialize;
    }
}
_SerializableCommand_commandTypeId = new WeakMap();
SerializableCommand.deserializationCallbacks = {};
exports.default = SerializableCommand;
