import AbstractComponent from '../components/AbstractComponent';
import Editor from '../Editor';
import { EditorLocalization } from '../localization';
import SerializableCommand from './SerializableCommand';
/**
 * A command that duplicates the {@link AbstractComponent}s it's given. This command
 * is the reverse of an {@link Erase} command.
 *
 * @example
 * ```ts
 * // Given some editor...
 *
 * // Find all elements intersecting the rectangle with top left (0,0) and
 * // (width,height)=(100,100).
 * const elems = editor.image.getComponentsIntersecting(
 * 	new Rect2(0, 0, 100, 100)
 * );
 *
 * // Create a command that, when applied, will duplicate the elements.
 * const duplicateElems = new Duplicate(elems);
 *
 * // Apply the command (and make it undoable)
 * editor.dispatch(duplicateElems);
 * ```
 *
 * @see {@link Editor.dispatch} {@link EditorImage.getComponentsIntersecting}
 */
export default class Duplicate extends SerializableCommand {
    private toDuplicate;
    private duplicates;
    private reverse;
    constructor(toDuplicate: AbstractComponent[], idsForDuplicates?: string[]);
    apply(editor: Editor): void;
    unapply(editor: Editor): void;
    onDrop(editor: Editor): void;
    description(_editor: Editor, localizationTable: EditorLocalization): string;
    protected serializeToJSON(): {
        originalIds: string[];
        cloneIds: string[];
    };
}
