"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _UndoRedoHistory_undoStack, _UndoRedoHistory_redoStack;
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./types");
class UndoRedoHistory {
    // @internal
    constructor(editor, announceRedoCallback, announceUndoCallback) {
        this.editor = editor;
        this.announceRedoCallback = announceRedoCallback;
        this.announceUndoCallback = announceUndoCallback;
        _UndoRedoHistory_undoStack.set(this, void 0);
        _UndoRedoHistory_redoStack.set(this, void 0);
        this.maxUndoRedoStackSize = 700;
        __classPrivateFieldSet(this, _UndoRedoHistory_undoStack, [], "f");
        __classPrivateFieldSet(this, _UndoRedoHistory_redoStack, [], "f");
    }
    fireUpdateEvent(stackUpdateType, triggeringCommand) {
        this.editor.notifier.dispatch(types_1.EditorEventType.UndoRedoStackUpdated, {
            kind: types_1.EditorEventType.UndoRedoStackUpdated,
            undoStackSize: __classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").length,
            redoStackSize: __classPrivateFieldGet(this, _UndoRedoHistory_redoStack, "f").length,
            command: triggeringCommand,
            stackUpdateType,
        });
    }
    // Adds the given command to this and applies it to the editor.
    push(command, apply = true) {
        if (apply) {
            command.apply(this.editor);
        }
        __classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").push(command);
        for (const elem of __classPrivateFieldGet(this, _UndoRedoHistory_redoStack, "f")) {
            elem.onDrop(this.editor);
        }
        __classPrivateFieldSet(this, _UndoRedoHistory_redoStack, [], "f");
        if (__classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").length > this.maxUndoRedoStackSize) {
            const removeAtOnceCount = Math.ceil(this.maxUndoRedoStackSize / 100);
            const removedElements = __classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").splice(0, removeAtOnceCount);
            removedElements.forEach((elem) => elem.onDrop(this.editor));
        }
        this.fireUpdateEvent(types_1.UndoEventType.CommandDone, command);
        this.editor.notifier.dispatch(types_1.EditorEventType.CommandDone, {
            kind: types_1.EditorEventType.CommandDone,
            command,
        });
    }
    // Remove the last command from this' undo stack and apply it.
    undo() {
        const command = __classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").pop();
        if (command) {
            __classPrivateFieldGet(this, _UndoRedoHistory_redoStack, "f").push(command);
            const result = command.unapply(this.editor);
            this.announceUndoCallback(command);
            this.fireUpdateEvent(types_1.UndoEventType.CommandUndone, command);
            this.editor.notifier.dispatch(types_1.EditorEventType.CommandUndone, {
                kind: types_1.EditorEventType.CommandUndone,
                command,
            });
            return result;
        }
    }
    redo() {
        const command = __classPrivateFieldGet(this, _UndoRedoHistory_redoStack, "f").pop();
        if (command) {
            __classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").push(command);
            const result = command.apply(this.editor);
            this.announceRedoCallback(command);
            this.fireUpdateEvent(types_1.UndoEventType.CommandRedone, command);
            this.editor.notifier.dispatch(types_1.EditorEventType.CommandDone, {
                kind: types_1.EditorEventType.CommandDone,
                command,
            });
            return result;
        }
    }
    get undoStackSize() {
        return __classPrivateFieldGet(this, _UndoRedoHistory_undoStack, "f").length;
    }
    get redoStackSize() {
        return __classPrivateFieldGet(this, _UndoRedoHistory_redoStack, "f").length;
    }
}
_UndoRedoHistory_undoStack = new WeakMap(), _UndoRedoHistory_redoStack = new WeakMap();
exports.default = UndoRedoHistory;
