import Editor from './Editor';
import Command from './commands/Command';
type AnnounceRedoCallback = (command: Command) => void;
type AnnounceUndoCallback = (command: Command) => void;
declare class UndoRedoHistory {
    #private;
    private readonly editor;
    private announceRedoCallback;
    private announceUndoCallback;
    private readonly maxUndoRedoStackSize;
    constructor(editor: Editor, announceRedoCallback: AnnounceRedoCallback, announceUndoCallback: AnnounceUndoCallback);
    private fireUpdateEvent;
    push(command: Command, apply?: boolean): void;
    undo(): void | Promise<void>;
    redo(): void | Promise<void>;
    get undoStackSize(): number;
    get redoStackSize(): number;
}
export default UndoRedoHistory;
