import { Rect2 } from '@js-draw/math';
import { ComponentAddedListener, ImageLoader, OnDetermineExportRectListener, OnProgressListener } from '../types';
export declare const defaultSVGViewRect: Rect2;
export declare const svgAttributesDataKey = "svgAttrs";
export declare const svgStyleAttributesDataKey = "svgStyleAttrs";
export declare const svgLoaderAttributeContainerID = "svgContainerID";
export declare const svgLoaderAutoresizeClassName = "js-draw--autoresize";
export type SVGLoaderUnknownAttribute = [string, string];
export type SVGLoaderUnknownStyleAttribute = {
    key: string;
    value: string;
    priority?: string;
};
export interface SVGLoaderControl {
    /** Call this to add a component to the editor. */
    addComponent: ComponentAddedListener;
}
/**
 * Loads custom components from an SVG image.
 * @see SVGLoader.fromString
 */
export interface SVGLoaderPlugin {
    /**
     * Called when the {@link SVGLoader} encounters a `node`.
     *
     * Call `loader.addComponent` to add new components to the image.
     *
     * Returning `true` prevents the {@link SVGLoader} from doing further
     * processing on the node.
     */
    visit(node: Element, loader: SVGLoaderControl): Promise<boolean>;
}
export declare enum SVGLoaderLoadMethod {
    IFrame = "iframe",
    DOMParser = "domparser"
}
export interface SVGLoaderOptions {
    sanitize?: boolean;
    disableUnknownObjectWarnings?: boolean;
    plugins?: SVGLoaderPlugin[];
    loadMethod?: SVGLoaderLoadMethod;
}
export default class SVGLoader implements ImageLoader {
    private source;
    private onFinish;
    private onAddComponent;
    private onProgress;
    private onDetermineExportRect;
    private processedCount;
    private totalToProcess;
    private rootViewBox;
    private readonly storeUnknown;
    private readonly disableUnknownObjectWarnings;
    private readonly plugins;
    private constructor();
    private getStyle;
    private strokeDataFromElem;
    private attachUnrecognisedAttrs;
    private addPath;
    private addBackground;
    private getComputedStyle;
    private getTransform;
    private makeText;
    private addText;
    private addImage;
    private addUnknownNode;
    private containerGroupIDs;
    private encounteredIDs;
    private startGroup;
    private endGroup;
    private addComponent;
    private updateViewBox;
    private updateSVGAttrs;
    private visit;
    private getSourceAttrs;
    start(onAddComponent: ComponentAddedListener, onProgress: OnProgressListener, onDetermineExportRect?: OnDetermineExportRectListener | null): Promise<void>;
    /**
     * Create an `SVGLoader` from the content of an SVG image. SVGs are loaded within a sandboxed
     * iframe with `sandbox="allow-same-origin"`
     * [thereby disabling JavaScript](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox).
     *
     * @see {@link Editor.loadFrom}
     * @param text - Textual representation of the SVG (e.g. `<svg viewbox='...'>...</svg>`).
     * @param options - if `true` or `false`, treated as the `sanitize` option -- don't store unknown attributes.
     */
    static fromString(text: string, options?: Partial<SVGLoaderOptions> | boolean): SVGLoader;
}
