import { Point2, Vec2 } from '@js-draw/math';
import Viewport from './Viewport';
export declare enum PointerDevice {
    Pen = 0,
    Eraser = 1,
    Touch = 2,
    PrimaryButtonMouse = 3,
    RightButtonMouse = 4,
    Other = 5
}
export default class Pointer {
    readonly screenPos: Point2;
    readonly canvasPos: Point2;
    readonly pressure: number | null;
    readonly isPrimary: boolean;
    readonly down: boolean;
    readonly device: PointerDevice;
    readonly id: number;
    readonly timeStamp: number;
    private constructor();
    /**
     * Snaps this pointer to the nearest grid point (rounds the coordinates of this
     * pointer based on the current zoom). Returns a new Pointer and does not modify
     * this.
     */
    snappedToGrid(viewport: Viewport): Pointer;
    lockedToXYAxesScreen(originPointScreen: Vec2, viewport: Viewport): Pointer;
    /** @see {@link withCanvasPosition} */
    withScreenPosition(screenPos: Point2, viewport: Viewport): Pointer;
    /** Returns a copy of this pointer with a changed timestamp. */
    withTimestamp(timeStamp: number): Pointer;
    /**
     * Returns a copy of this pointer with a new position. The screen position is determined
     * by the given `canvasPos`.
     */
    withCanvasPosition(canvasPos: Point2, viewport: Viewport): Pointer;
    static ofEvent(evt: PointerEvent, isDown: boolean, viewport: Viewport, relativeTo?: HTMLElement): Pointer;
    static ofCanvasPoint(canvasPos: Point2, isDown: boolean, viewport: Viewport, id?: number, device?: PointerDevice, isPrimary?: boolean, pressure?: number | null, timeStamp?: number | null): Pointer;
    static ofScreenPoint(screenPos: Point2, isDown: boolean, viewport: Viewport, id?: number, device?: PointerDevice, isPrimary?: boolean, pressure?: number | null, timeStamp?: number | null): Pointer;
}
