type CallbackHandler<EventType> = (data: EventType) => void;
export interface DispatcherEventListener {
    remove: () => void;
}
/**
 * Handles notifying listeners of events.
 *
 * `EventKeyType` is used to distinguish events (e.g. a `ClickEvent` vs a `TouchEvent`)
 * while `EventMessageType` is the type of the data sent with an event (can be `void`).
 *
 * @example
 * ```
 * const dispatcher = new EventDispatcher<'event1'|'event2'|'event3', void>();
 * dispatcher.on('event1', () => {
 *   console.log('Event 1 triggered.');
 * });
 * dispatcher.dispatch('event1');
 * ```
 *
 */
export default class EventDispatcher<EventKeyType extends string | symbol | number, EventMessageType> {
    private listeners;
    constructor();
    dispatch(eventName: EventKeyType, event: EventMessageType): void;
    on(eventName: EventKeyType, callback: CallbackHandler<EventMessageType>): DispatcherEventListener;
    /** Removes an event listener. This is equivalent to calling `.remove()` on the object returned by `.on`. */
    off(eventName: EventKeyType, callback: CallbackHandler<EventMessageType>): void;
}
export {};
