import boxen from 'boxen';

/**
 * Log a warning message to stderr
 * @param message The message to warn
 */
export function warn(message: string) {
  console.error(
    boxen(message, { title: 'WARNING', borderColor: 'yellow', padding: { top: 0, left: 1, right: 1, bottom: 0 } }),
  );
}
