import { groupBy, unique } from '../../util/array.js';
import { insertDescriptionCommentStatementBeforeLine, insertDisableCommentStatementBeforeLine, mergeDescription, mergeRuleIds, parseDisableComment, updateDisableComment, } from '../../util/eslint.js';
import { notEmpty } from '../../util/type-check.js';
function findDisableCommentPerLine(sourceCode, line) {
    const commentsInFile = sourceCode.getAllComments();
    const commentsInPreviousLine = commentsInFile.filter((comment) => { var _a; return ((_a = comment.loc) === null || _a === void 0 ? void 0 : _a.start.line) === line - 1; });
    return commentsInPreviousLine.map(parseDisableComment).find((comment) => (comment === null || comment === void 0 ? void 0 : comment.scope) === 'next-line');
}
function generateFixesPerLine(context, description, descriptionPosition, line, messagesInLine) {
    const { fixer, sourceCode } = context;
    const ruleIdsToDisable = unique(messagesInLine.map((message) => message.ruleId).filter(notEmpty));
    if (ruleIdsToDisable.length === 0)
        return [];
    const disableCommentPerLine = findDisableCommentPerLine(sourceCode, line);
    const fixes = [];
    const isPreviousLine = description !== undefined && descriptionPosition === 'previousLine';
    if (isPreviousLine) {
        fixes.push(insertDescriptionCommentStatementBeforeLine({
            fixer,
            sourceCode,
            line: disableCommentPerLine ? disableCommentPerLine.loc.start.line : line,
            description,
        }));
    }
    if (disableCommentPerLine) {
        fixes.push(updateDisableComment({
            fixer,
            disableComment: disableCommentPerLine,
            newRules: mergeRuleIds(disableCommentPerLine.ruleIds, ruleIdsToDisable),
            newDescription: isPreviousLine
                ? disableCommentPerLine.description
                : mergeDescription(disableCommentPerLine.description, description),
        }));
    }
    else {
        fixes.push(insertDisableCommentStatementBeforeLine({
            fixer,
            sourceCode,
            line,
            scope: 'next-line',
            ruleIds: ruleIdsToDisable,
            description: isPreviousLine ? undefined : description,
        }));
    }
    return fixes;
}
/**
 * Create fix to add disable comment per line.
 */
export function createFixToDisablePerLine(context, args) {
    const lineToMessages = groupBy(context.messages, (message) => message.line);
    const fixes = [];
    for (const [line, messagesInLine] of lineToMessages) {
        fixes.push(...generateFixesPerLine(context, args.description, args.descriptionPosition, line, messagesInLine));
    }
    return fixes;
}
//# sourceMappingURL=disable-per-line.js.map