"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeGlobsToRoot = exports.extractGlobsFromMatcher = exports.buildGlobMatcher = exports.extractGlobExcludesFromConfig = exports.calcExcludeGlobInfo = exports.extractPatterns = exports.calcGlobs = exports.globP = void 0;
const cspell_glob_1 = require("cspell-glob");
const glob_1 = __importDefault(require("glob"));
const path = __importStar(require("path"));
const defaultExcludeGlobs = ['node_modules/**'];
// Note this is to allow experimenting with using a single glob
const useJoinPatterns = process.env['CSPELL_SINGLE_GLOB'];
/**
 *
 * @param pattern - glob patterns and NOT file paths. It can be a file path turned into a glob.
 * @param options - search options.
 */
async function globP(pattern, options) {
    const root = (options === null || options === void 0 ? void 0 : options.root) || process.cwd();
    const opts = options || { root };
    const rawPatterns = typeof pattern === 'string' ? [pattern] : pattern;
    const normPatterns = useJoinPatterns ? joinPatterns(rawPatterns) : rawPatterns;
    const globPState = {
        options: { ...opts, root },
    };
    const globResults = normPatterns.map(async (pat) => {
        globPState.options = { ...opts, root: root, cwd: root };
        const absolutePaths = (await _globP(pat, globPState)).map((filename) => path.resolve(root, filename));
        const relativeToRoot = absolutePaths.map((absFilename) => path.relative(root, absFilename));
        return relativeToRoot;
    });
    const results = new Set(flatten(await Promise.all(globResults)));
    return [...results];
}
exports.globP = globP;
function joinPatterns(globs) {
    return globs.length <= 1 ? globs : [`{${globs.join(',')}}`];
}
function _globP(pattern, state) {
    if (!pattern) {
        return Promise.resolve([]);
    }
    return new Promise((resolve, reject) => {
        const cb = (err, matches) => {
            if (err) {
                reject(err);
            }
            resolve(matches);
        };
        const options = { ...(state.glob || {}), ...state.options };
        state.glob = (0, glob_1.default)(pattern, options, cb);
    });
}
function calcGlobs(commandLineExclude) {
    const globs = (commandLineExclude || [])
        .map((glob) => glob.split(/(?<!\\)\s+/g))
        .map((globs) => globs.map((g) => g.replace(/\\ /g, ' ')))
        .reduce((s, globs) => {
        globs.forEach((g) => s.add(g));
        return s;
    }, new Set());
    const commandLineExcludes = {
        globs: [...globs],
        source: 'arguments',
    };
    const defaultExcludes = {
        globs: defaultExcludeGlobs,
        source: 'default',
    };
    return commandLineExcludes.globs.length ? commandLineExcludes : defaultExcludes;
}
exports.calcGlobs = calcGlobs;
function extractPatterns(globs) {
    const r = globs.reduce((info, g) => {
        const source = g.source;
        const patterns = g.matcher.patternsNormalizedToRoot;
        return info.concat(patterns.map((glob) => ({ glob, source })));
    }, []);
    return r;
}
exports.extractPatterns = extractPatterns;
function calcExcludeGlobInfo(root, commandLineExclude) {
    commandLineExclude = typeof commandLineExclude === 'string' ? [commandLineExclude] : commandLineExclude;
    const choice = calcGlobs(commandLineExclude);
    const matcher = new cspell_glob_1.GlobMatcher(choice.globs, { root, dot: true });
    return [
        {
            matcher,
            source: choice.source,
        },
    ];
}
exports.calcExcludeGlobInfo = calcExcludeGlobInfo;
function extractGlobExcludesFromConfig(root, source, config) {
    if (!config.ignorePaths || !config.ignorePaths.length) {
        return [];
    }
    const matcher = new cspell_glob_1.GlobMatcher(config.ignorePaths, { root, dot: true });
    return [{ source, matcher }];
}
exports.extractGlobExcludesFromConfig = extractGlobExcludesFromConfig;
/**
 * Build GlobMatcher from command line or config file globs.
 * @param globs Glob patterns or file paths
 * @param root - directory to use as the root
 */
function buildGlobMatcher(globs, root, isExclude) {
    const withRoots = globs.map((g) => {
        const source = typeof g === 'string' ? 'command line' : undefined;
        return { source, ...(0, cspell_glob_1.fileOrGlobToGlob)(g, root) };
    });
    return new cspell_glob_1.GlobMatcher(withRoots, { root, mode: isExclude ? 'exclude' : 'include' });
}
exports.buildGlobMatcher = buildGlobMatcher;
function extractGlobsFromMatcher(globMatcher) {
    return globMatcher.patternsNormalizedToRoot.map((g) => g.glob);
}
exports.extractGlobsFromMatcher = extractGlobsFromMatcher;
function normalizeGlobsToRoot(globs, root, isExclude) {
    return extractGlobsFromMatcher(buildGlobMatcher(globs, root, isExclude));
}
exports.normalizeGlobsToRoot = normalizeGlobsToRoot;
function* flatten(src) {
    for (const item of src) {
        if (Array.isArray(item)) {
            yield* item;
        }
        else {
            yield item;
        }
    }
}
//# sourceMappingURL=glob.js.map