import type { CSpellUserSettings, Glob } from '@cspell/cspell-types';
import { GlobMatcher, GlobPatternWithRoot } from 'cspell-glob';
/**
 * This is a subset of IOptions from 'glob'.
 */
export interface GlobOptions {
    cwd?: string | undefined;
    root?: string | undefined;
    dot?: boolean | undefined;
    nodir?: boolean | undefined;
    ignore?: string | ReadonlyArray<string> | undefined;
}
/**
 *
 * @param pattern - glob patterns and NOT file paths. It can be a file path turned into a glob.
 * @param options - search options.
 */
export declare function globP(pattern: string | string[], options?: GlobOptions): Promise<string[]>;
export declare function calcGlobs(commandLineExclude: string[] | undefined): {
    globs: string[];
    source: string;
};
export interface GlobSrcInfo {
    matcher: GlobMatcher;
    source: string;
}
interface ExtractPatternResult {
    glob: GlobPatternWithRoot;
    source: string;
}
export declare function extractPatterns(globs: GlobSrcInfo[]): ExtractPatternResult[];
export declare function calcExcludeGlobInfo(root: string, commandLineExclude: string[] | string | undefined): GlobSrcInfo[];
export declare function extractGlobExcludesFromConfig(root: string, source: string, config: CSpellUserSettings): GlobSrcInfo[];
/**
 * Build GlobMatcher from command line or config file globs.
 * @param globs Glob patterns or file paths
 * @param root - directory to use as the root
 */
export declare function buildGlobMatcher(globs: Glob[], root: string, isExclude: boolean): GlobMatcher;
export declare function extractGlobsFromMatcher(globMatcher: GlobMatcher): string[];
export declare function normalizeGlobsToRoot(globs: Glob[], root: string, isExclude: boolean): string[];
export {};
//# sourceMappingURL=glob.d.ts.map