/// <reference types="node" />
import { CSpellUserSettings, Document, Issue } from 'cspell-lib';
import { GlobOptions } from './glob';
export interface ConfigInfo {
    source: string;
    config: CSpellUserSettings;
}
export interface FileConfigInfo {
    configInfo: ConfigInfo;
    filename: string;
    text: string;
    languageIds: string[];
}
export declare function readConfig(configFile: string | undefined, root: string | undefined): Promise<ConfigInfo>;
export interface FileInfo {
    filename: string;
    text?: string;
    errorCode?: string;
}
export interface FileResult {
    fileInfo: FileInfo;
    processed: boolean;
    issues: Issue[];
    errors: number;
    configErrors: number;
    elapsedTimeMs: number | undefined;
    cached?: boolean;
}
export declare function fileInfoToDocument(fileInfo: FileInfo, languageId: string | undefined, locale: string | undefined): Document;
interface ReadFileInfoResult extends FileInfo {
    text: string;
}
export declare function readFileInfo(filename: string, encoding?: BufferEncoding, handleNotFound?: boolean): Promise<ReadFileInfoResult>;
export declare function readFile(filename: string, encoding?: BufferEncoding): Promise<string>;
/**
 * Looks for matching glob patterns or stdin
 * @param globPatterns patterns or stdin
 */
export declare function findFiles(globPatterns: string[], options: GlobOptions): Promise<string[]>;
export declare function calcFinalConfigInfo(configInfo: ConfigInfo, settingsFromCommandLine: CSpellUserSettings, filename: string, text: string): FileConfigInfo;
/**
 * Read
 * @param listFiles - array of file paths to read that will contain a list of files. Paths contained in each
 *   file will be resolved relative to the containing file.
 * @returns - a list of files to be processed.
 */
export declare function readFileListFiles(listFiles: string[]): AsyncIterable<string>;
/**
 * Read a `listFile` and return the containing file paths resolved relative to the `listFile`.
 * @param listFiles - array of file paths to read that will contain a list of files. Paths contained in each
 *   file will be resolved relative to the containing file.
 * @returns - a list of files to be processed.
 */
export declare function readFileListFile(listFile: string): Promise<string[]>;
export declare function isFile(filename: string): Promise<boolean>;
export declare function isDir(filename: string): Promise<boolean>;
export declare function isNotDir(filename: string): Promise<boolean>;
export {};
//# sourceMappingURL=fileHelper.d.ts.map