"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toApplicationError = exports.isError = exports.toError = exports.IOError = exports.ApplicationError = exports.CheckFailed = void 0;
const util_1 = require("util");
class CheckFailed extends Error {
    constructor(message, exitCode = 1) {
        super(message);
        this.exitCode = exitCode;
    }
}
exports.CheckFailed = CheckFailed;
class ApplicationError extends Error {
    constructor(message, exitCode = 1, cause) {
        super(message);
        this.exitCode = exitCode;
        this.cause = cause;
    }
}
exports.ApplicationError = ApplicationError;
class IOError extends ApplicationError {
    constructor(message, cause) {
        super(message, undefined, cause);
        this.cause = cause;
    }
    get code() {
        return this.cause.code;
    }
    isNotFound() {
        return this.cause.code === 'ENOENT';
    }
}
exports.IOError = IOError;
function toError(e) {
    if (isError(e))
        return e;
    const message = (0, util_1.format)(e);
    return {
        name: 'error',
        message,
        toString: () => message,
    };
}
exports.toError = toError;
function isError(e) {
    if (e instanceof Error)
        return true;
    if (!e || typeof e !== 'object')
        return false;
    const ex = e;
    return typeof ex.message === 'string';
}
exports.isError = isError;
function toApplicationError(e, message) {
    if (e instanceof ApplicationError && !message)
        return e;
    const err = toError(e);
    return new ApplicationError(message !== null && message !== void 0 ? message : err.message, undefined, err);
}
exports.toApplicationError = toApplicationError;
//# sourceMappingURL=errors.js.map